/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ViewportEvent;

public class RollAnimator
extends Animator {
    private final Roll.Direction direction;

    public RollAnimator(Roll.Direction direction) {
        this.direction = direction;
    }

    public static float calculateMovementFactor(float progress) {
        return -MathUtil.squaring(progress - 1.0f) + 1.0f;
    }

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(Roll.class).isDoing();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        Roll roll = parkourability.get(Roll.class);
        float phase = ((float)roll.getDoingTick() + transformer.getPartialTick()) / (float)roll.getRollMaxTick();
        float factor = 1.0f - 4.0f * (0.5f - phase) * (0.5f - phase);
        transformer.addRotateLeftLeg((float)Math.toRadians(-70.0f * factor), 0.0f, 0.0f).addRotateRightLeg((float)Math.toRadians(-70.0f * factor), 0.0f, 0.0f).addRotateRightArm((float)Math.toRadians(-80.0f * factor), 0.0f, 0.0f).addRotateLeftArm((float)Math.toRadians(-80.0f * factor), 0.0f, 0.0f).end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        Roll roll = parkourability.get(Roll.class);
        float phase = ((float)roll.getDoingTick() + rotator.getPartialTick()) / (float)roll.getRollMaxTick();
        float factor = RollAnimator.calculateMovementFactor(phase);
        float sign = this.direction == Roll.Direction.Front ? 1.0f : -1.0f;
        rotator.startBasedCenter().rotateFrontward(sign * MathUtil.lerp(0.0f, 360.0f, factor)).end();
    }

    @Override
    public void onCameraSetUp(ViewportEvent.ComputeCameraAngles event, Player clientPlayer, Parkourability parkourability) {
        float sign;
        Roll roll = parkourability.get(Roll.class);
        float f = sign = this.direction == Roll.Direction.Front ? 1.0f : -1.0f;
        if (roll.isDoing() && clientPlayer.m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && !((Boolean)ParCoolConfig.CONFIG_CLIENT.disableCameraRolling.get()).booleanValue()) {
            float factor = RollAnimator.calculateMovementFactor((float)(((double)roll.getDoingTick() + event.getPartialTick()) / (double)roll.getRollMaxTick()));
            event.setPitch(sign * ((double)factor > 0.5 ? factor - 1.0f : factor) * 360.0f + clientPlayer.m_5686_((float)event.getPartialTick()));
        }
    }
}

